#!/bin/sh

########################################
# common string
########################################
STRING_CANCEL="Cancel"
STRING_BACK="Back"
STRING_SAVE="Save"
STRING_DETACH="Detach"
STRING_YES="Yes"
STRING_OK="OK"
STRING_SELECT="Next"
STRING_EXIT="Log off"
STRING_HOST_IP="IP address:"
STRING_USERNAME="User name:"
STRING_PASSWORD="Password:"
STRING_USE_DHCP="Dynamic (DHCP)"
STRING_USE_STATIC_IP="Static"
STRING_IP_ADDRESS="*IPv4 address:"
STRING_NETMASK="*Subnet mask:"
STRING_GATEWAY="*IPv4 gateway:"
STRING_DNS="*DNS server 1:"
STRING_DNS2=" DNS server 2:"
STRING_DNS3=" DNS server 3:"
STRING_IPV6_ADDRESS=" IPv6 address:"
STRING_IPV6_PREFIX_LENGTH=" Subnet prefix length:"
STRING_IPV6_GATEWAY=" IPv6 gateway:"
STRING_MS_IP="Management Server IP address:"
STRING_ESXI_USERNAME="ESXi username:"
STRING_ESXI_PASSWORD="ESXi password:"

########################################
# add/remove sandbox image tmp file path
########################################
ORIGIN_SB_GROUP_INFO_ESXI_FILE="${CONS_ECLI_DIR}OriSBGroupInfoESXi"
ORIGIN_SB_GROUP_INFO_VIX_FILE="${CONS_ECLI_DIR}OriSBGroupInfoVIX"
NEW_SB_GROUP_INFO_ESXI_FILE="${CONS_ECLI_DIR}NewSBGroupInfoESXi"
NEW_SB_GROUP_INFO_VIX_FILE="${CONS_ECLI_DIR}NewSBGroupInfoVIX"
NEW_SB_GROUP_TO_BE_REMOVED_FILE="${CONS_ECLI_DIR}NewSBGroupToBeRemoved"
NEW_SB_GROUP_TO_BE_KEPT_FILE="${CONS_ECLI_DIR}NewSBGroupToBeKept"
NEW_SB_GROUP_TO_BE_ADDED_FILE="${CONS_ECLI_DIR}NewSBGroupToBeAdded"
NEW_SB_ADDED_FILE="${CONS_ECLI_DIR}NewSBAdded"

########################################
# ERROR MSG (msgbox)
########################################
ERROR_TITLE="Error Message"
ERROR_LABEL_OK="OK"
ERROR_UNKNOWN="Unknown Error"

########################################
# general error msg
########################################
ERROR_ESXI_WRONG_USERNAME_PASSWORD="Cannot connect to the VMware ESXi server. Verify that the user name and password are correct."
ERROR_ESXI_WRONG_SERVER_UNAVAILABLE="Cannot connect to the VMware ESXi server. Please check the network connected."
ERROR_ESXI_CANNOT_GET_IMAGE_PATH_DATASTORE="Images not found. The datastores containing images must start with \"datastore\".\n\
For example: datastore1 , datastore_1, or datastore-1. Spaces and special characters are not supported."
ERROR_ESXI_CANNOT_GET_IMAGE_PATH_MS="Management Server image not found. The image name must start with \"ManagementServer\".\n\
For example: ManagementServer1 , ManagementServer_1, or ManagementServer-1. Spaces and special characters are not supported."
ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SC="Sandbox Controller image not found. The image name must start with \"SandboxController\".\n\
For example: SandboxController1 , SandboxController_1, or SandboxController-1. Spaces and special characters are not supported."
ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SB="Custom sandbox images not found. Image names must start with \"DDA_\".\n\
For example: DDA_1. Spaces and special characters are not supported."
ERROR_DO_NOT_KILL="It is not possible to quit this screen at this time."
ERROR_USER_COLUMN_EMPTY="User Name column is empty"

########################################
# Strings used in tp_esxi_image_select
########################################
TP_ESXI_IMAGE_SELECT_ERROR_GET_DS_MAPPING="Cannot retrieve datastore mapping."
TP_ESXI_IMAGE_SELECT_ERROR_DATASTORE_IS_NOT_FOUND="Image files not found."
TP_ESXI_IMAGE_SELECT_ERROR_SPLIT_DS_MAPPING="Cannot split datastore mapping."
TP_ESXI_IMAGE_SELECT_ERROR_GET_VMPATH_ALL="Cannot retrieve VM paths."
TP_ESXI_IMAGE_SELECT_ERROR_GET_VMPATH_PREFIX="Cannot retrieve VM paths with prefix."
TP_ESXI_IMAGE_SELECT_ERROR_CONVERT_DS_UUID_TO_NAME="Cannot convert datastore UUID to Name."
TP_ESXI_IMAGE_SELECT_ERROR_CONVERT_TO_ESXI_VMPATH="Cannot convert to VM path."
TP_ESXI_IMAGE_SELECT_ERROR_GET_ALL_VMX_FILES="Cannot retrieve all vmx files."
TP_ESXI_IMAGE_SELECT_ERROR_GET_IMAGE_TYPE_ID="Cannot retrieve image type ID."


########################################
# Strings used in tp_ip_username_password
########################################
TP_IP_USERNAME_PASSWORD_ERROR_INVALID_ARGUMENT="Invalid Argument"
TP_IP_DIVIDER_USERNAME_PASSWORD_ERROR_INVALID_ARGUMENT="Invalid Argument"
TP_STRING_IP="IP"


########################################
# Strings used in tp_username_password
########################################
TP_USERNAME_PASSWORD_ERROR_INVALID_USERNAME="Type a valid user name."
TP_USERNAME_PASSWORD_ERROR_INVALID_PASSWORD="Type a valid password."


########################################
# Strings used in tp_network_conf
########################################
TP_NETWORK_CONF_ERROR_INVALID_IP="Type a valid IPv4 address."
TP_NETWORK_CONF_ERROR_INVALID_NETMASK="Type a valid subnet mask."
TP_NETWORK_CONF_ERROR_INVALID_GATEWAY="Type a valid IPv4 gateway address."
TP_NETWORK_CONF_ERROR_INVALID_DNS_V6="Type a valid IPv4 or IPv6 address for DNS server 1."
TP_NETWORK_CONF_ERROR_INVALID_DNS2_V6="Type a valid IPv4 or IPv6 address for DNS server 2."
TP_NETWORK_CONF_ERROR_INVALID_DNS3_V6="Type a valid IPv4 or IPv6 address for DNS server 3."
TP_NETWORK_CONF_ERROR_INVALID_DNS="Type a valid IPv4 address for DNS server 1."
TP_NETWORK_CONF_ERROR_INVALID_DNS2="Type a valid IPv4 address for DNS server 2."
TP_NETWORK_CONF_ERROR_INVALID_DNS3="Type a valid IPv4 address for DNS server 3."

TP_NETWORK_CONF_ERROR_SYSTEM_LOCKED="Unable to perform the selected action. Deep Discovery Director is configuring critical system settings. Please try again later."
TP_NETWORK_CONF_MSG_WAIT="Deep Discovery Director will begin to configure the settings. The preconfiguration console may momentarily become unresponsive. Click OK to continue."
TP_NETWORK_CONF_ERROR_EMPTY_IP_AND_IPV6="Type a valid IPv4 and/or IPv6 address."
TP_NETWORK_CONF_ERROR_INVALID_IPV6="Type a valid IPv6 address."
TP_NETWORK_CONF_ERROR_INVALID_IPV6_PREFIX_LENGTH="Type a valid prefix length."
TP_NETWORK_CONF_ERROR_INVALID_IPV6_GATEWAY="Type a valid IPv6 gateway address."
TP_NETWORK_CONF_ERROR_IP_EMPTY="Type a valid IPv4 address."
TP_NETWORK_CONF_ERROR_IPV6_EMPTY="Type a valid IPv6 address."
TP_NETWORK_CONF_ERROR_IPV4_ADDRESS_CONFLICT="The IP address is already used by another host."
TP_NETWORK_CONF_ERROR_IPV6_ADDRESS_CONFLICT="The IP address is already used by another host."
TP_NETWORK_CONF_ERROR_INVALID_IPV4_4_VIP="Type a IPv4 address that is in the same network segment as the high availability IPv4 virtual address."
TP_NETWORK_CONF_ERROR_INVALID_IPV6_4_VIP="Type a IPv6 address that is in the same network segment as the high availability IPv6 virtual address."
TP_NETWORK_CONF_ERROR_INVALID_IPV6_NULL="Type a valid IPv6 address, or delete high availability IPv6 virtual address."
TP_NETWORK_CONF_ERROR_INVALID_IPV6_CHANGE="The IPv6 address cannot be modified when using high availability."

########################################
# Strings used in tp_ping
########################################
TP_PING_ERROR_INVALID_IP_FQDN="Type a valid IP address or FQDN."

########################################
# Strings used in tp_msg_ok
########################################
TP_MSG_OK_ERROR_UNKNOWN_ERROR="Uknown Error"


########################################
# Deployment mode -> EULA
########################################
DPLY_PAGE_EULA_MESSAGE_EXIT="Press arrow keys on the keyboard to scroll. Press Q to proceed."


########################################
# Deployment mode -> EULA_ACCEPT
########################################
DPLY_PAGE_EULA_ACCEPT_TITLE="License Agreement"
DPLY_PAGE_EULA_ACCEPT_LABEL_OK="Accept"
DPLY_PAGE_EULA_ACCEPT_LABEL_CANCEL="Back"
DPLY_PAGE_EULA_ACCEPT_MESSAGE_CONFIRM="Accept the terms of the License Agreement. Select <Back> to review the License Agreement again."


########################################
# Deployment mode -> INFRASTRUCT_SELECT
########################################
DPLY_PAGE_INFRA_SELECT_TITLE="Number of Devices"
DPLY_PAGE_INFRA_SELECT_TEXT="Select the number of devices in your organization."
DPLY_PAGE_INFRA_SELECT_LABEL_OK="One"
DPLY_PAGE_INFRA_SELECT_LABEL_CANCEL="More than one"
DPLY_PAGE_INFRA_SELECT_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_INFRA_SELECT_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> MODE_SELECT
########################################
DPLY_PAGE_MODE_SELECT_TITLE="Device Role"
DPLY_PAGE_MODE_SELECT_TEXT="Select the role of the device in the cluster."
DPLY_PAGE_MODE_SELECT_LABEL_OK="Master"
DPLY_PAGE_MODE_SELECT_LABEL_CANCEL="Slave"
DPLY_PAGE_MODE_SELECT_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_MODE_SELECT_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> MS_DHCP_OR_STATIC
########################################
DPLY_PAGE_MS_DHCP_OR_STATIC_TITLE="Management Server IP Address"
DPLY_PAGE_MS_DHCP_OR_STATIC_TEXT="Assign an IP address to the Management Server."
DPLY_PAGE_MS_DHCP_OR_STATIC_LABEL_OK="Next"
DPLY_PAGE_MS_DHCP_OR_STATIC_LABEL_CANCEL="Back"
DPLY_PAGE_MS_DHCP_OR_STATIC_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
DPLY_PAGE_MS_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_MS_DHCP_OR_STATIC_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> MS_NETWORK_CONF
########################################
DPLY_PAGE_MS_NETWORK_CONF_TITLE="Configure Network Settings"
DPLY_PAGE_MS_NETWORK_CONF_TEXT="Type the network settings."
DPLY_PAGE_MS_NETWORK_CONF_LABEL_OK="Next"
DPLY_PAGE_MS_NETWORK_CONF_LABEL_CANCEL="Back"
DPLY_PAGE_MS_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
DPLY_PAGE_MS_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_MS_NETWORK_CONF_ERROR_UNKNOWN="Unknown error"

########################################
# Deployment mode -> DATA_NETWORK_CONF
########################################
DPLY_PAGE_DATA_NETWORK_CONF_TITLE="Appliance Data IP Settings"
DPLY_PAGE_DATA_NETWORK_CONF_TEXT="Configure static IP address settings."
DPLY_PAGE_DATA_NETWORK_CONF_LABEL_OK="Next"
DPLY_PAGE_DATA_NETWORK_CONF_LABEL_CANCEL="Back"
DPLY_PAGE_DATA_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
DPLY_PAGE_DATA_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_DATA_NETWORK_CONF_ERROR_UNKNOWN="Unknown error"




########################################
# Deployment mode -> ESXI_INFO_CONF
########################################
DPLY_PAGE_ESXI_INFO_CONF_TITLE="VMware ESXi Server Settings"
DPLY_PAGE_ESXI_INFO_CONF_TEXT="Type the VMware ESXi server logon credentials."
DPLY_PAGE_ESXI_INFO_CONF_LABEL_OK="Next"
DPLY_PAGE_ESXI_INFO_CONF_LABEL_CANCEL="Back"
DPLY_PAGE_ESXI_INFO_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_ESXI_INFO_CONF_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> SC_Image
########################################
DPLY_PAGE_SC_IMAGE_PATH_SELECT_TITLE="Sandbox Controller Image"
DPLY_PAGE_SC_IMAGE_PATH_SELECT_TEXT="Select the Sandbox Controller image to use."
DPLY_PAGE_SC_IMAGE_PATH_SELECT_LABEL_OK="Next"
DPLY_PAGE_SC_IMAGE_PATH_SELECT_LABEL_CANCEL="Back"

DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_COMPOSING_MENU="Cannot show image."
DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_GENERATE_SSH_KEY="Cannot generate SSH key."
DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_COPY_SSH_KEY_TO_SC="Cannot copy SSH key to SandboxController."
DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> SC_DHCP_OR_STATIC
########################################
DPLY_PAGE_SC_DHCP_OR_STATIC_TITLE="Sandbox Controller IP Address"
DPLY_PAGE_SC_DHCP_OR_STATIC_TEXT="Assign an IP address to the Sandbox Controller."
DPLY_PAGE_SC_DHCP_OR_STATIC_LABEL_OK="Next"
DPLY_PAGE_SC_DHCP_OR_STATIC_LABEL_CANCEL="Back"
DPLY_PAGE_SC_DHCP_OR_STATIC_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
DPLY_PAGE_SC_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_SC_DHCP_OR_STATIC_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> SC_NETWORK_CONF
########################################
DPLY_PAGE_SC_NETWORK_CONF_TITLE="Sandbox Controller Static IP Settings"
DPLY_PAGE_SC_NETWORK_CONF_TEXT="Configure static IP address settings."
DPLY_PAGE_SC_NETWORK_CONF_LABEL_OK="Next"
DPLY_PAGE_SC_NETWORK_CONF_LABEL_CANCEL="Back"
DPLY_PAGE_SC_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
DPLY_PAGE_SC_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_SC_NETWORK_CONF_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> SB_Image
########################################
DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE="Sandbox Images to Clone"
DPLY_PAGE_SB_IMAGE_PATH_SELECT_TEXT="Below are the sandbox images (without the 'DDA_' prefix) currently stored in the system.\n\
Select up to %s images. The selected images will be cloned to create the sandboxes.\n\
Be sure that the images are powered off before proceeding."
DPLY_PAGE_SB_IMAGE_PATH_SELECT_LABEL_OK="Next"
DPLY_PAGE_SB_IMAGE_PATH_SELECT_LABEL_CANCEL="Back"

DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_COMPOSING_MENU="Cannot show images."
DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_UNKNOWN="Unknown error"
DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_TOO_MANY_IMAGES="Be sure that only %s images are selected."
DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_NO_IMAGES="No image was selected."
DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_POWEROFF_IMAGE="Be sure to power off the selected image(s)."
DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_NOT_MULTIPLES="Total number of sandboxes (%s) must be multiples of image count (%s)."

########################################
# Deployment mode -> SB_IMAGE_SELECT_NO_IMAGE
########################################
DPLY_PAGE_SB_IMAGE_PATH_SELECT_NO_IMAGE_TITLE="Sandbox Images to Clone"
DPLY_PAGE_SB_IMAGE_PATH_SELECT_NO_IMAGE_TEXT="No image was selected."
DPLY_PAGE_SB_IMAGE_PATH_SELECT_NO_IMAGE_LABEL_OK="OK"


########################################
# Deployment mode -> SB_IMAGE_SELECT_TOO_MANY_IMAGE
########################################
DPLY_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TITLE="Sandbox Images to Clone"
DPLY_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TEXT="Be sure that only %s images are selected."
DPLY_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_LABEL_OK="OK"

########################################
# Deployment mode -> SB_NUM
########################################
DPLY_PAGE_SB_NUM_CONF_TITLE="Number of Sandboxes"
DPLY_PAGE_SB_NUM_CONF_TEXT="Type the number of sandboxes to create from the sandbox images. Up to %s sandboxes can be created."
DPLY_PAGE_SB_NUM_CONF_OK_LABEL="Next"
DPLY_PAGE_SB_NUM_CONF_CANCEL_LABEL="Back"
DPLY_PAGE_SB_NUM_CONF_INVALID_ARGUMENT="Type a number between 1 and %s."
DPLY_PAGE_SB_NUM_CONF_INVALID_NUM="Type a number between 1 and %s."


########################################
# Deployment mode -> VERIFY_SETTINGS
########################################
DPLY_PAGE_VERIFY_SETTINGS_TITLE="Installation Settings"
DPLY_PAGE_VERIFY_SETTINGS_TEXT="Below are the installation settings. Select <Back> to make changes."
DPLY_PAGE_VERIFY_SETTINGS_LABEL_OK="Install"
DPLY_PAGE_VERIFY_SETTINGS_LABEL_CANCEL="Back"


########################################
# Deployment mode -> DEPLOYING
########################################
DPLY_PAGE_DEPLOYING_TITLE="Installation Status"
DPLY_PAGE_DEPLOYING_TEXT="This process may take up to one hour to complete."
DPLY_PAGE_DEPLOYING_ERROR_LAUNCH_SCRIPT="Cannot retrieve deployment script (deploy.sh)."
DPLY_PAGE_DEPLOYING_ERROR_DURING_DEPLOYING="Deployment error"
DPLY_PAGE_DEPLOYING_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_DEPLOYING_ERROR_NETWORK_ADAPTERS_OCCUPIED="The physical network adapters are not available. Verify that there are at least two available adapters available and that no vSwitch group is using vmnic1.\n\
Note: vmnic1 is the dedicated adapter for Deep Discovery Director. If a vSwitch group is using vmnic1, reconfigure it to make vmnic1 available for Deep Discovery Director."

########################################
# Deployment mode -> DEPLOYING_DONE
########################################
DPLY_PAGE_DEPLOYING_DONE_TITLE="Installation Complete"
DPLY_PAGE_DEPLOYING_DONE_TEXT="Deep Discovery Director has been installed and includes:\n\
\n\
      *  A Management Server\n\
      *  Virtual Analyzer (Sandbox Controller, NAT, and %s sandboxes)"
DPLY_PAGE_DEPLOYING_DONE_LABEL_OK="OK"
DPLY_PAGE_DEPLOYING_DONE_ERROR_SYNC_SETTING_TO_SC="Cannot synchronize settings with the Sandbox Controller."
DPLY_PAGE_DEPLOYING_DONE_ERROR_SWITCH_TO_MASTER_MODE="Cannot switch to master mode."
DPLY_PAGE_DEPLOYING_DONE_NETWORK_CHECK_TITLE="Network Not Available"
DPLY_PAGE_DEPLOYING_DONE_NETWORK_CHECK_TEXT="The Management Console is not able to access. Please check the network connected."
DPLY_PAGE_DEPLOYING_DONE_NETWORK_CHECK_LABEL_OK="OK"


########################################
# Deployment mode -> SB_INTERNET_CONN
########################################
DPLY_PAGE_SB_INTERNET_CONN_TITLE="Sandbox Internet Connection"
DPLY_PAGE_SB_INTERNET_CONN_TEXT="Trend Micro recommends enabling Internet connection without proxy settings, proxy authentication, and Internet connection restrictions/policies for a proper simulation of malware behavior when connecting to the Internet."
DPLY_PAGE_SB_INTERNET_CONN_LABEL_OK="Next"
DPLY_PAGE_SB_INTERNET_CONN_LABEL_CANCEL="Back"
DPLY_PAGE_SB_INTERNET_CONN_ITEM_1="Enable"
DPLY_PAGE_SB_INTERNET_CONN_ITEM_2="Disable"
DPLY_PAGE_SB_INTERNET_CONN_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_SB_INTERNET_CONN_ERROR_ISOLATE="Cannot disable Internet connection."


########################################
# Deployment mode -> NAT_DHCP_OR_STATIC
########################################
DPLY_PAGE_NAT_DHCP_OR_STATIC_TITLE="NAT IP Address"
DPLY_PAGE_NAT_DHCP_OR_STATIC_TEXT="Assign an IP address to the NAT virtual machine. NAT connects the Sandbox Controller to the sandboxes, and the sandboxes to the Internet (if Internet connection is enabled)."
DPLY_PAGE_NAT_DHCP_OR_STATIC_LABEL_OK="Next"
DPLY_PAGE_NAT_DHCP_OR_STATIC_LABEL_CANCEL="Back"
DPLY_PAGE_NAT_DHCP_OR_STATIC_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
DPLY_PAGE_NAT_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_NAT_DHCP_OR_STATIC_ERROR_UNKNOWN="Unknown error"


########################################
# Deployment mode -> SC_NETWORK_CONF
########################################
DPLY_PAGE_NAT_NETWORK_CONF_TITLE="NAT Static IP Settings"
DPLY_PAGE_NAT_NETWORK_CONF_TEXT="Configure static IP address settings."
DPLY_PAGE_NAT_NETWORK_CONF_LABEL_OK="Next"
DPLY_PAGE_NAT_NETWORK_CONF_LABEL_CANCEL="Back"
DPLY_PAGE_NAT_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
DPLY_PAGE_NAT_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
DPLY_PAGE_NAT_NETWORK_CONF_ERROR_UNKNOWN="Unknown error"


########################################
# auto detect network change
########################################
ASK_RECONFIG_NETWORK_TITLE="Device Reconfiguration"
ASK_RECONFIG_NETWORK_MSG="This device may need to be reconfigured. Possible reasons:\n\
* The management and data ports of the device are now connected to a different Management Network and Malware Lab Network. If this is the case, the Management Server and NAT IP addresses assigned to the device must be updated.\n\
* If you have several devices, this device is currently a slave device. You can change the role to master if there is no master device currently. Remember that only one device at a time can act as master.\n\
Do you want to reconfigure this device?"
AFTER_NETWORK_RECONFIG_FAIL_TO_SYNC_IP="Internal error"

########################################
# Master mode -> main settings
########################################
MASTER_PAGE_MAIN_SETTINGS_TITLE="Main Menu"
MASTER_PAGE_MAIN_SETTINGS_TEXT="Configure Deep Discovery Director."
MASTER_PAGE_MAIN_SETTINGS_LABEL_OK=$STRING_SELECT
MASTER_PAGE_MAIN_SETTINGS_ITEM_1="Configure network settings"
#MASTER_PAGE_MAIN_SETTINGS_ITEM_2="View high availability details"
#MASTER_PAGE_MAIN_SETTINGS_ITEM_2="Configure appliance Data IP address"
MASTER_PAGE_MAIN_SETTINGS_ITEM_2="Ping remote host"
MASTER_PAGE_MAIN_SETTINGS_ITEM_3="Manage user accounts"
MASTER_PAGE_MAIN_SETTINGS_ITEM_4="Enable/Disable SSH access"
MASTER_PAGE_MAIN_SETTINGS_ITEM_5=$STRING_EXIT

########################################
# Master mode -> ping
########################################
MASTER_PAGE_PING_TITLE="Ping Remote Host"
MASTER_PAGE_PING_TEXT="Type a valid IP address or FQDN."
MASTER_PAGE_PING_LABEL_OK="Ping"
MASTER_PAGE_PING_LABEL_CANCEL=$STRING_BACK
PING_TITLE="Ping Response"

########################################
# Master mode -> ESXi configure
########################################
MASTER_PAGE_ESXI_CONF_TITLE="Configuration Tasks"
MASTER_PAGE_ESXI_CONF_TEXT="Configure Deep Discovery Director."
MASTER_PAGE_ESXI_CONF_LABEL_OK=$STRING_SELECT
MASTER_PAGE_ESXI_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_ESXI_CONF_ITEM_1="Update VMware ESXi Server settings"
MASTER_PAGE_ESXI_CONF_ITEM_2="Update Management Server IP address"
MASTER_PAGE_ESXI_CONF_ITEM_3="Enable/Disable Internet connection for sandboxes"
MASTER_PAGE_ESXI_CONF_ITEM_4="Update NAT IP address"
MASTER_PAGE_ESXI_CONF_ITEM_5="Configure debug log settings"
MASTER_PAGE_ESXI_CONF_ITEM_6="View API key"
MASTER_PAGE_ESXI_CONF_ITEM_7="Manage logon accounts for preconfiguration console"
MASTER_PAGE_ESXI_CONF_ITEM_8="Reconfigure sandboxes"
# strings for single image version
# MASTER_PAGE_ESXI_CONF_ITEM_8_1="Delete all sandboxes"
# MASTER_PAGE_ESXI_CONF_ITEM_8_2="Install sandboxes"
MASTER_PAGE_ESXI_CONF_ITEM_9="View Sandbox Controller status"

########################################
# Master mode -> ESXi info conf
########################################
MASTER_PAGE_ESXI_INFO_CONF_TITLE="VMware ESXi Server Settings"
MASTER_PAGE_ESXI_INFO_CONF_TEXT="The VMWare ESXi server logon credentials (user name and password) can only be updated from the VMware ESXi server console. After updating the credentials, apply the same updates on this screen so that the Management Server can access the VMware ESXi server using the new credentials. See the Online Help for details on updating the logon credentials from the VMware ESXi server console."
MASTER_PAGE_ESXI_INFO_CONF_LABEL_OK=$STRING_SAVE
MASTER_PAGE_ESXI_INFO_CONF_LABEL_CANCEL=$STRING_BACK

########################################
# Master mode -> ms dhcp or static
########################################
MASTER_PAGE_MS_DHCP_OR_STATIC_TITLE="Server IP Address"
MASTER_PAGE_MS_DHCP_OR_STATIC_TEXT="Update the Server IP address."
MASTER_PAGE_MS_DHCP_OR_STATIC_LABEL_OK=$STRING_SAVE
MASTER_PAGE_MS_DHCP_OR_STATIC_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_MS_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION="Configuration error"

########################################
# Master mode -> ms netwok conf
########################################
MASTER_PAGE_MS_NETWORK_CONF_TITLE="Configure Network Settings"
MASTER_PAGE_MS_NETWORK_CONF_TEXT="Type the network settings."
MASTER_PAGE_MS_NETWORK_CONF_LABEL_OK=$STRING_SAVE
MASTER_PAGE_MS_NETWORK_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_MS_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
MASTER_PAGE_MS_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Invalid settings. Verify that the IP address is not currently in use and that the other settings are correct."

########################################
# Master mode -> data netwok conf
########################################
MASTER_PAGE_DATA_NETWORK_CONF_TITLE="Appliance Data IP Settings"
MASTER_PAGE_DATA_NETWORK_CONF_TEXT="Type the appliance Data IP settings."
MASTER_PAGE_DATA_NETWORK_CONF_LABEL_OK=$STRING_SAVE
MASTER_PAGE_DATA_NETWORK_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_DATA_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
MASTER_PAGE_DATA_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Invalid settings. Verify that the IP address is not currently in use and that the other settings are correct."



########################################
# Master mode -> sb dhcp or static
########################################
MASTER_PAGE_SC_DHCP_OR_STATIC_TITLE="Sandbox Controller IP Address"
MASTER_PAGE_SC_DHCP_OR_STATIC_TEXT="Update the Sandbox Controller IP address."
MASTER_PAGE_SC_DHCP_OR_STATIC_LABEL_OK=$STRING_SAVE
MASTER_PAGE_SC_DHCP_OR_STATIC_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_SC_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION="Configuration error"

########################################
# Master mode -> sc netwok conf
########################################
MASTER_PAGE_SC_NETWORK_CONF_TITLE="Sandbox Controller Static IP Settings"
MASTER_PAGE_SC_NETWORK_CONF_TEXT="Type the appliance IP settings."
MASTER_PAGE_SC_NETWORK_CONF_LABEL_OK=$STRING_SAVE
MASTER_PAGE_SC_NETWORK_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_SC_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration."
MASTER_PAGE_SC_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"

########################################
# Master mode -> sb netwok conf
########################################
MASTER_PAGE_SB_INTERNET_CONN_TITLE="Internet Connection for Sandboxes"
MASTER_PAGE_SB_INTERNET_CONN_TEXT="TrendMicro recommends enabling Internet connection without proxy settings, proxy authentication, and Internet connection restrictions/policies for a proper simulation of malware behavior when connecting to the Internet."
MASTER_PAGE_SB_INTERNET_CONN_LABEL_OK=$STRING_SAVE
MASTER_PAGE_SB_INTERNET_CONN_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_SB_INTERNET_CONN_ITEM_1="Enable"
MASTER_PAGE_SB_INTERNET_CONN_ITEM_2="Disable"

MASTER_PAGE_SB_INTERNET_ERROR_REMOVE_CLUSTER_TEXT="Before reconfiguring Internet connection for sandboxes, remove all slave devices from the cluster. To do this, go back to the main menu and select 'Manage slave devices'. In the next screen, select a slave device. In the next screen, select 'Remove from cluster' and then follow the on-screen instructions.\n\
Note: Manually add the slave devices back to the cluster after reconfiguring Internet connection for sandboxes."

########################################
# Master mode -> nat no connection warning
########################################
MASTER_PAGE_NAT_NO_CONN_WARNING_TITLE="NAT IP Address"
MASTER_PAGE_NAT_NO_CONN_WARNING_TEXT="\
To update NAT settings, Internet connection for sandboxes must be enabled.\n\
\n\
To enable Internet connection for sandboxes, select <Back>. In the main menu, select 'Enable/Disable Internet connection for sandboxes' and then follow the on-screen instructions."
MASTER_PAGE_NAT_NO_CONN_WARNING_LABEL_OK=$STRING_BACK


########################################
# Master mode -> nat dhcp or static
########################################
MASTER_PAGE_NAT_DHCP_OR_STATIC_TITLE="NAT IP Address"
MASTER_PAGE_NAT_DHCP_OR_STATIC_TEXT="Update the NAT IP address."
MASTER_PAGE_NAT_DHCP_OR_STATIC_LABEL_OK=$STRING_SAVE
MASTER_PAGE_NAT_DHCP_OR_STATIC_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NAT_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION="Configuration error"

########################################
# Master mode -> nat netwok conf
########################################
MASTER_PAGE_NAT_NETWORK_CONF_TITLE="NAT Static IP Settings"
MASTER_PAGE_NAT_NETWORK_CONF_TEXT="Type the appliance IP settings."
MASTER_PAGE_NAT_NETWORK_CONF_LABEL_OK=$STRING_SAVE
MASTER_PAGE_NAT_NETWORK_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NAT_NETWORK_CONF_ERROR_SAVE_CONFIGURATION="Configuration error"
MASTER_PAGE_NAT_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF="Cannot apply network configuration"

########################################
# Master mode -> log configure
########################################
MASTER_PAGE_LOG_CONF_TITLE="Debug Log Tasks"
MASTER_PAGE_LOG_CONF_TEXT="If you encounter issues with Virtual Analyzer, enable debug logging and then collect the resulting debug logs to help troubleshoot the issues.\n\
Since debug logging may affect performance, enable debug logging only when necessary and promptly disable it if you no longer need debug data."
MASTER_PAGE_LOG_CONF_LABEL_OK=$STRING_SAVE
MASTER_PAGE_LOG_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_LOG_CONF_ITEM_1="Enable/Disable debug logging"
MASTER_PAGE_LOG_CONF_ITEM_2="Collect logs"
MASTER_PAGE_LOG_CONF_DEBUGLOG_FILE_AVAILABLE_AT="Download the debug log file.\n\
1. On any computer that can connect to the Management Server, open an Internet Explorer or Firefox browser window.\n\
2. Type the following URL in the address bar and press Enter"
MASTER_PAGE_LOG_CONF_FAIL_TO_COLLECT_DEBUGLOG="Cannot collect debug logs."

########################################
# Master mode -> log enable/disable
########################################
MASTER_PAGE_LOG_ENABLE_TITLE="Debug Logging"
MASTER_PAGE_LOG_ENABLE_TEXT="Enable or disable debug logging."
MASTER_PAGE_LOG_ENABLE_LABEL_OK=$STRING_SAVE
MASTER_PAGE_LOG_ENABLE_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_LOG_ENABLE_ITEM_1="Enable"
MASTER_PAGE_LOG_ENABLE_ITEM_2="Disable"
MASTER_PAGE_LOG_ENABLE_INVALID_ARGUMENT="Invalid argument"

########################################
# Master mode -> log settings
########################################
MASTER_PAGE_LOG_SETTINGS_TITLE="Debug Logging Settings"
MASTER_PAGE_LOG_SETTINGS_TEXT="Debug logs can consume a large amount of disk space. The following settings prevent the system from running out of disk space.\n\
If you accept the default settings (5 log files, 10MB each), Deep Discovery Director creates the first log file and starts to record logs to that file. When the size of that log file has reached 10MB, the product creates the second log file and the process repeats. When the fifth log file has reached 10MB in size, the product starts to record logs to the first log file, overwriting existing data."
MASTER_PAGE_LOG_SETTINGS_LABEL_OK=$STRING_SAVE
MASTER_PAGE_LOG_SETTINGS_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_LOG_SETTINGS_MAX_ROTATE="Maximum number of log files:"
MASTER_PAGE_LOG_SETTINGS_SIZE_LIMIT="Maximum size (in MB) of each log file:"
MASTER_PAGE_LOG_SETTINGS_OUTPUT_FILE="Location of log files:"
MASTER_PAGE_LOG_SETTINGS_INVALID_ARGUMENT="Invalid argument"
MASTER_PAGE_LOG_SETTINGS_INTERNAL_ERROR="Internal error"

########################################
# Master mode -> display api key
########################################
MASTER_PAGE_DISPLAY_API_KEY_TITLE="API Key"
MASTER_PAGE_DISPLAY_API_KEY_SUBTITLE="Trend Micro products use the API key to register to Deep Discovery Director and send samples for analysis. For a list of products and supported versions, see the Deep Discovery Director Online Help.\n\
Record the API key shown on this screen and then type it on the management console of the integrating product.\n\
Note: The API key is also available on the Deep Discovery Director management console, in 'Administration > About Deep Discovery Director'."
MASTER_PAGE_DISPLAY_API_KEY_LABEL_OK=$STRING_OK

########################################
# Master mode -> accounts management
########################################
MASTER_PAGE_ACCOUNTS_MNGT_TITLE="Manage User Accounts"
MASTER_PAGE_ACCOUNTS_MNGT_TEXT="Add an account or modify settings for an existing account.\nNote: These accounts can only be used on the pre-configuration console."
MASTER_PAGE_ACCOUNTS_MNGT_OK_LABEL=$STRING_SELECT
MASTER_PAGE_ACCOUNTS_MNGT_CANCEL_LABEL=$STRING_BACK
MASTER_PAGE_ACCOUNTS_MNGT_ITEM_1="Add account"
MASTER_PAGE_ACCOUNTS_MNGT_INTERNAL_ERROR="Internal error"
MASTER_PAGE_ACCOUNTS_MNGT_PERMISSION_DENY="It is not possible to modify the account '%s' while logged on as '%s'."

########################################
# Master mode -> sshd enable
########################################
MASTER_PAGE_SSHD_ENABLE_TITLE="Enable/Disable SSH Access"
MASTER_PAGE_SSHD_ENABLE_TEXT="Enable or disable SSH access to the preconfiguration console.\nNote: Users that are currently logged on are automatically logged off when SSH access is disabled."
MASTER_PAGE_SSHD_ENABLE_ITEM_ENABLE="Enabled"
MASTER_PAGE_SSHD_ENABLE_ITEM_DISABLE="Disabled"
MASTER_PAGE_SSHD_ENABLE_SYSTEM_ERROR="Fail to change sshd service status"
MASTER_PAGE_SSHD_ENABLE_OK_LABEL=$STRING_SELECT
MASTER_PAGE_SSHD_ENABLE_CANCEL_LABEL=$STRING_BACK


########################################
# Master mode -> new account name setting
########################################
MASTER_PAGE_NEW_ACCOUNT_NAME_TITLE="Add Account"
MASTER_PAGE_NEW_ACCOUNT_NAME_TEXT="Type a user name with 1 to 31 characters."
MASTER_PAGE_NEW_ACCOUNT_NAME_OK_LABEL=$STRING_SAVE
MASTER_PAGE_NEW_ACCOUNT_NAME_CANCEL_LABEL=$STRING_BACK
MASTER_PAGE_NEW_ACCOUNT_NAME_INVALID_ARGUMENT="Type a valid user name."
MASTER_PAGE_NEW_ACCOUNT_NAME_ALREADY_EXISTS="The user name already exists. Type a unique user name."

########################################
# Master mode -> account configuration
########################################
MASTER_PAGE_ACCOUNT_CONF_TITLE="Manage User Accounts"
MASTER_PAGE_ACCOUNT_CONF_TEXT="Select the action to perform on account '%s'."
MASTER_PAGE_ACCOUNT_CONF_OK_LABEL=$STRING_SELECT
MASTER_PAGE_ACCOUNT_CONF_CANCEL_LABEL=$STRING_BACK
MASTER_PAGE_ACCOUNT_CONF_ITEM_1="Change password"
MASTER_PAGE_ACCOUNT_CONF_ITEM_2="Delete account"
MASTER_PAGE_ACCOUNT_CONF_INTERNAL_ERROR="Internal error"
MASTER_PAGE_ACCOUNT_CONF_DELETE_TITLE="Delete Account"
MASTER_PAGE_ACCOUNT_CONF_DELETE_MSG="Do you want to continue deleting the account?"
MASTER_PAGE_ACCOUNT_CONF_CANT_DELETE_YOURSELF="Unable to delete the account. The user is currently logged on."
MASTER_PAGE_ACCOUNT_CONF_DELETE_LOGGED_IN_ACCOUNT="Unable to delete the account. The user is currently logged on."

########################################
# Master mode -> ms new password
########################################
MASTER_PAGE_MS_NEW_PASSWORD_TITLE="Add Account"
MASTER_PAGE_MS_NEW_PASSWORD_TEXT="Type a password with 1 to 64 characters."
MASTER_PAGE_MS_NEW_PASSWORD_LABEL_OK=$STRING_SAVE
MASTER_PAGE_MS_NEW_PASSWORD_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_MS_NEW_PASSWORD_PASSWORD="New password:"
MASTER_PAGE_MS_NEW_PASSWORD_RETYPE_PASSWORD="Confirm password:"
MASTER_PAGE_MS_NEW_PASSWORD_DO_NOT_MATCH="The passwords do not match. Please try again."

########################################
# Master mode -> ms change password
########################################
MASTER_PAGE_MS_CHANGE_PASSWORD_TITLE="Change password"
MASTER_PAGE_MS_CHANGE_PASSWORD_TEXT="Type a password with 1 to 64 characters."
MASTER_PAGE_MS_CHANGE_PASSWORD_LABEL_OK=$STRING_SAVE
MASTER_PAGE_MS_CHANGE_PASSWORD_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_MS_CHANGE_PASSWORD_PASSWORD="New password:"
MASTER_PAGE_MS_CHANGE_PASSWORD_RETYPE_PASSWORD="Confirm password:"
MASTER_PAGE_MS_CHANGE_PASSWORD_DO_NOT_MATCH="The passwords do not match. Please try again."

########################################
# Master mode -> ha
########################################
MASTER_PAGE_HA_TITLE="High Availability"
MASTER_PAGE_HA_TEXT="View high-availability settings."
MASTER_PAGE_HA_LABEL_OK=$STRING_DETACH
MASTER_PAGE_HA_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_HA_LABEL_CANCEL2=$STRING_CANCEL

MASTER_PAGE_HA_PASSWORD="New password:"
MASTER_PAGE_HA_RETYPE_PASSWORD="Confirm password:"
MASTER_PAGE_HA_DO_NOT_MATCH="The passwords do not match. Please try again."
MASTER_PAGE_HA_ACTIVE_NODE="Primary (active)"
MASTER_PAGE_HA_ACTIVE_DETAIL="Active appliance details"
MASTER_PAGE_HA_STANDBY_NODE="Primary (passive)"
MASTER_PAGE_HA_STANDBY_DETAIL="Passive appliance details"
MASTER_PAGE_HA_SINGLE_DESC="This appliance has not been configured to use high availability."
MASTER_PAGE_HA_DETACH_TITLE="Detach Passive Primary Appliance"
MASTER_PAGE_HA_DISCONNECTED="Disconnected"
MASTER_PAGE_HA_FULLY_SYNCED="Fully synced"
MASTER_PAGE_HA_SYNCED="synced"
MASTER_PAGE_HA_SYNCING="Syncing"
MASTER_PAGE_HA_DETACH_CONFORM_MSG="\
\n\
Detaching the passive primary appliance disables high availability.\n\
\n\
\n\
Do you want to continue?"


########################################
# Master mode -> reconfig sb
########################################
MASTER_PAGE_SB_RECONFIG_REMOVE_CLUSTER_TITLE="Sandbox Reconfiguration"
MASTER_PAGE_SB_RECONFIG_REMOVE_CLUSTER_TEXT="Before reconfiguring sandboxes, remove all slave devices from the cluster. To do this, go back to the main menu and select 'Manage slave devices'. In the next screen, select a slave device. In the next screen, select 'Remove from cluster' and then follow the on-screen instructions.\n\
Note: Manually add the slave devices back to the cluster after reconfiguring the sandboxes."
MASTER_PAGE_SB_RECONFIG_REMOVE_CLUSTER_OK_LABEL=$STRING_OK

########################################
# Master mode -> SB_NUM
########################################
MASTER_PAGE_SB_NUM_CONF_TITLE="Number of Sandboxes"
MASTER_PAGE_SB_NUM_CONF_TEXT="Type the number of sandboxes to create from the sandbox images. Up to %s sandboxes can be created."
MASTER_PAGE_SB_NUM_CONF_OK_LABEL="Next"
MASTER_PAGE_SB_NUM_CONF_CANCEL_LABEL="Back"
MASTER_PAGE_SB_NUM_CONF_INVALID_ARGUMENT="Type a number between 1 and %s."
MASTER_PAGE_SB_NUM_CONF_INVALID_NUM="Type a number between 1 and %s."

########################################
# Master mode -> select sb img path
########################################
MASTER_PAGE_SB_IMAGE_PATH_SELECT_TITLE="Sandbox Images to Clone"
MASTER_PAGE_SB_IMAGE_PATH_SELECT_TEXT="Below are the sandbox images (without the 'DDA_' prefix) currently stored in the system.\n\
Select up to 3 images. The selected images will be cloned to reconfigure the sandboxes.\n\
Be sure that the images are powered off before proceeding."
MASTER_PAGE_SB_IMAGE_PATH_SELECT_LABEL_OK="Next"
MASTER_PAGE_SB_IMAGE_PATH_SELECT_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_COMPOSING_MENU="Cannot show images."
MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_SAVE_CONFIGURATION="Configuration error"
MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_UNKNOWN="Unknown error"
MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_POWEROFF_IMAGE="Be sure to power off the selected image(s)."
MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_NOT_MULTIPLES="Total number of sandboxes (%s) must be multiples of image count (%s)."

MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TITLE="Sandbox Images to Clone"
MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TEXT="Be sure that only %s images are selected."
MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_LABEL_OK=$STRING_OK


########################################
# Master mode -> Add/Remove Sandboxes -> Image Path Confirm
########################################
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_TITLE="Sandbox Distribution"
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_TEXT="Below are the selected sandbox images and the number of sandboxes that will be created from each image."
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_LABEL_OK="Next"
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_TEXT_REMOVE_ALL_SB="Warning: No image was selected. If you proceed, all existing sandboxes will be removed. To select images, select <Back>."


########################################
# Master mode -> reinstall sb
########################################
MASTER_PAGE_SB_REINSTALL_CALLING_DEPLOY_ERROR="Cannot retrieve deployment script."
MASTER_PAGE_SB_REINSTALL_DEPLOYING_ERROR="Deployment error"
MASTER_PAGE_SB_REINSTALL_TITLE="Reconfiguration Status"
MASTER_PAGE_SB_REINSTALL_SUBTITLE="This process may take up to one hour to complete."


########################################
# Master mode -> sb deploy done
########################################
MASTER_PAGE_SB_DEPLOY_DONE_ERROR_SAVE_CONFIGURATION="Configuration error"
MASTER_PAGE_SB_DEPLOY_DONE_TITLE="Reconfiguration Complete"
MASTER_PAGE_SB_DEPLOY_DONE_OK_LABEL=$STRING_OK
MASTER_PAGE_SB_DEPLOY_DONE_PAGE_SUBTITLE="Sandboxes have been reconfigured. There are currently %s sandboxes."
MASTER_PAGE_SB_DEPLOY_DONE_PAGE_SUBTITLE_REMOVE_ALL_SB="All sandboxes have been removed. Virtual Analyzer will not work until new sandboxes are created. To create new sandboxes, repeat the steps for reconfiguring sandboxes."
MASTER_PAGE_SB_DEPLOY_DONE_ERROR_CLEANUP_DEPLOYMENT="Deployment error. Please try again."


########################################
# Master mode -> sc status
########################################
MASTER_PAGE_SC_STATUS_TITLE="View Sandbox Controller Status"
MASTER_PAGE_SC_STATUS_LABEL_OK=$STRING_OK


########################################
# Master mode -> additional esxi conf
########################################
MASTER_PAGE_ADDITIONAL_ESXI_CONF_TITLE="Slave Device Management"
MASTER_PAGE_ADDITIONAL_ESXI_CONF_TEXT="Add a new slave device to the cluster or configure the settings for an exising slave device.\n\
Important: Before adding a slave device, open its preconfiguration console and verify that it has been assigned as a slave. In addition, the master and slave devices must have identical sandbox images, number of sandboxes, and sandbox Internet connection setting. If these are not identical, reconfigure the devices before proceeding. For details, see the 'Cluster Deployment' topic in the Online Help."
MASTER_PAGE_ADDITIONAL_ESXI_CONF_OK_LABEL="Next"
MASTER_PAGE_ADDITIONAL_ESXI_CONF_CANCEL_LABEL=$STRING_BACK
MASTER_PAGE_ADDITIONAL_ESXI_CONF_ITEM_1="Add new slave device"
MASTER_PAGE_ADDITIONAL_ESXI_CONF_INTERNAL_ERROR="Internal error"
MASTER_PAGE_ADDITIONAL_ESXI_CONF_FIND_SCID_ERROR="Cannot find sc_id for $selected_cluster_name."


########################################
# Master mode -> add a new esxi
########################################
# MASTER_PAGE_ADD_ESXI_EXCEED_SEAT_COUNT="Unable to add cluster. Seat count exceeded:"
MASTER_PAGE_ADD_ESXI_EXCEED_SEAT_COUNT="The maximum number of slave devices (%s) has been reached. Please contact Trend Micro."
MASTER_PAGE_ADD_ESXI_INACTIVATE="The slave device cannot be added because the master device has not been activated. On the management console of the master device, go to 'Administration > Licensing' and type a valid Activation Key."

########################################
# Master mode -> new esxi name setting
########################################
MASTER_PAGE_NEW_ESXI_NAME_TITLE="Slave Device Name"
MASTER_PAGE_NEW_ESXI_NAME_TEXT="Type a name for the slave device."
MASTER_PAGE_NEW_ESXI_NAME_OK_LABEL="Next"
MASTER_PAGE_NEW_ESXI_NAME_CANCEL_LABEL=$STRING_BACK
MASTER_PAGE_NEW_ESXI_NAME_INVALID_ARGUMENT="Invalid argument"


########################################
# Master mode -> new esxi info conf
########################################
MASTER_PAGE_NEW_ESXI_INFO_CONF_TITLE="Slave Device Settings"
MASTER_PAGE_NEW_ESXI_INFO_CONF_TEXT="Type the Management Server IP address and VMWare ESXi server logon credentials of the slave device."
MASTER_PAGE_NEW_ESXI_INFO_CONF_LABEL_OK="Next"
MASTER_PAGE_NEW_ESXI_INFO_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NEW_ESXI_INFO_CONF_INTERNAL_ERROR="Internal error"
MASTER_PAGE_NEW_ESXI_INFO_CONF_CLUSTER_ALREADY_EXIST_ERROR="The specified IP address is currently in use. Type a different IP address."


########################################
# Master mode -> new esxi ms image path
########################################
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_TITLE="Management Server Image"
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_TEXT="Select the Management Server image to use."
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_LABEL_OK="Next"
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_INVALID_SLAVE_STATUS="The slave device cannot be added to this cluster. Possible reasons for this include:\n\
* The slave device has already been assigned as a slave in this cluster.\n\
* The slave device has been assigned as a slave in another cluster. If so, detach this device from that cluster.\n\
* The settings for the master and slave devices are not identical. If so, match the settings for sandbox images, number of sandboxes, and sandbox Internet connection.\n\
For details, see the 'Cluster Deployment' topic in the Online Help."



########################################
# Master mode -> new esxi sc image path
########################################
MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_TITLE="Sandbox Controller Image"
MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_TEXT="Select the Sandbox Controller image to use."
MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_LABEL_OK="Next"
MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_LABEL_CANCEL=$STRING_BACK


########################################
# Master mode -> save esxi (no UI)
########################################
MASTER_PAGE_SAVE_ESXI_INTERNAL_ERROR="Internal error"


########################################
# Master mode -> new esxi sc dhcp or static
########################################
MASTER_PAGE_NEW_ESXI_SC_DHCP_OR_STATIC_TITLE="Sandbox Controller IP Address"
MASTER_PAGE_NEW_ESXI_SC_DHCP_OR_STATIC_TEXT="Assign an IP address to the Sandbox Controller of the slave device."
MASTER_PAGE_NEW_ESXI_SC_DHCP_OR_STATIC_LABEL_OK="Next"
MASTER_PAGE_NEW_ESXI_SC_DHCP_OR_STATIC_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NEW_ESXI_SC_DHCP_OR_STATIC_INTERNAL_ERROR="Internal error"


########################################
# Master mode -> new esxi sc network conf
########################################
MASTER_PAGE_NEW_ESXI_SC_NETWORK_CONF_TITLE="Sandbox Controller Static IP Settings"
MASTER_PAGE_NEW_ESXI_SC_NETWORK_CONF_TEXT="Configure static IP address settings for the Sandbox Controller of the slave device."
MASTER_PAGE_NEW_ESXI_SC_NETWORK_CONF_LABEL_OK="Next"
MASTER_PAGE_NEW_ESXI_SC_NETWORK_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NEW_ESXI_SC_NETWORK_CONF_INTERNAL_ERROR="Internal error"


########################################
# Master mode -> new esxi nat dhcp or static
########################################
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_TITLE="NAT IP Address"
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_TEXT="Assign an IP address to the NAT virtual machine of the slave device."
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_LABEL_OK=$STRING_SAVE
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_INTERNAL_ERROR="Internal Error"


########################################
# Master mode -> new esxi nat network conf
########################################
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_TITLE="NAT Static IP Settings"
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_TEXT="Configure static IP address settings for the NAT virtual machine of the slave device."
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_LABEL_OK=$STRING_SAVE
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_INTERNAL_ERROR="Internal error"


########################################
# Master mode -> esxi update
########################################
MASTER_PAGE_ESXI_UPDATE_TITLE="Slave Device Configuration Tasks"
MASTER_PAGE_ESXI_UPDATE_TEXT="Configure Deep Discovery Director."
MASTER_PAGE_ESXI_UPDATE_ITEM_1="Update slave device settings"
MASTER_PAGE_ESXI_UPDATE_ITEM_2="Remove from cluster"
MASTER_PAGE_ESXI_UPDATE_LABEL_OK=$STRING_SAVE
MASTER_PAGE_ESXI_UPDATE_LABEL_CANCEL=$STRING_BACK

########################################
# Master mode -> esxi info update
########################################
MASTER_PAGE_ESXI_INFO_UPDATE_TITLE="Slave Device Settings"
MASTER_PAGE_ESXI_INFO_UPDATE_TEXT="Update the Management Server IP address of the slave device.\n\
The VMWare ESXi server logon credentials (user name and password) can only be updated from the VMware ESXi server console of the slave device. After updating the credentials, apply the same updates on this screen so that the Management Server can access the VMware ESXi server using the new credentials. See the Online Help for details on updating the logon credentials from the VMware ESXi server console."
MASTER_PAGE_ESXI_INFO_UPDATE_LABEL_OK=$STRING_SAVE
MASTER_PAGE_ESXI_INFO_UPDATE_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_ESXI_INFO_UPDATE_INVALID_ARGUMENT="Invalid argument"

########################################
# Master mode -> esxi sc dhcp or static update
########################################
MASTER_PAGE_ESXI_SC_DHCP_OR_STATIC_UPDATE_TITLE="Sandbox Controller IP Address"
MASTER_PAGE_ESXI_SC_DHCP_OR_STATIC_UPDATE_TEXT="Update the Sandbox Controller IP address of the slave device."
MASTER_PAGE_ESXI_SC_DHCP_OR_STATIC_UPDATE_LABEL_OK=$STRING_SAVE
MASTER_PAGE_ESXI_SC_DHCP_OR_STATIC_UPDATE_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_ESXI_SC_DHCP_OR_STATIC_UPDATE_INTERNAL_ERROR="Internal Error"


########################################
# Master mode -> esxi sc network update
########################################
MASTER_PAGE_ESXI_SC_NETWORK_UPDATE_TITLE="Sandbox Controller Static IP Settings"
MASTER_PAGE_ESXI_SC_NETWORK_UPDATE_TEXT="Type the appliance IP settings."
MASTER_PAGE_ESXI_SC_NETWORK_UPDATE_LABEL_OK=$STRING_SAVE
MASTER_PAGE_ESXI_SC_NETWORK_UPDATE_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_ESXI_SC_NETWORK_UPDATE_INTERNAL_ERROR="Internal Error"


########################################
# Master mode -> esxi nat dhcp or static update
########################################
MASTER_PAGE_ESXI_NAT_DHCP_OR_STATIC_UPDATE_TITLE="NAT IP Address"
MASTER_PAGE_ESXI_NAT_DHCP_OR_STATIC_UPDATE_TEXT="Update the NAT IP address of the slave device."
MASTER_PAGE_ESXI_NAT_DHCP_OR_STATIC_UPDATE_LABEL_OK=$STRING_SAVE
MASTER_PAGE_ESXI_NAT_DHCP_OR_STATIC_UPDATE_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_ESXI_NAT_DHCP_OR_STATIC_UPDATE_INTERNAL_ERROR="Internal Error"

########################################
# Master mode -> esxi nat network update
########################################
MASTER_PAGE_ESXI_NAT_NETWORK_UPDATE_TITLE="NAT Static IP Settings"
MASTER_PAGE_ESXI_NAT_NETWORK_UPDATE_TEXT="Type the appliance IP settings."
MASTER_PAGE_ESXI_NAT_NETWORK_UPDATE_LABEL_OK=$STRING_SAVE
MASTER_PAGE_ESXI_NAT_NETWORK_UPDATE_LABEL_CANCEL=$STRING_BACK
MASTER_PAGE_ESXI_NAT_NETWORK_UPDATE_INTERNAL_ERROR="Internal Error"


########################################
# Master mode -> remove esxi
########################################
MASTER_PAGE_ESXI_REMOVE_TITLE="Slave Device Removal"
MASTER_PAGE_ESXI_REMOVE_TEXT="Select <Yes> to remove the slave device from the cluster. Select <No> to keep it in the cluster."
MASTER_PAGE_ESXI_REMOVE_INTERNAL_ERROR="Internal error"
MASTER_PAGE_ESXI_REMOVE_CLUSTER_INACCESSIBLE="Cannot connect to the slave device. Please check the network connected."

########################################
# Master mode -> switch to cluster mode
########################################
MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_TITLE="Device Role Modification"
MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_TEXT="Do you want to change the role of this device to slave?\n\
After changing the role, access the master device and add this device to the cluster."
MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_ERROR="Cannot change the role of this device to slave."
MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_NOTIFY="This device cannot change its role to slave. This device still has slave devices connected to it. Detach the slave devices from this master and try again."


########################################
# Cluster mode -> MAIN_MENU
########################################
CLST_PAGE_MAIN_MENU_TITLE="Device Role Modification"
CLST_PAGE_MAIN_MENU_TEXT="Select the role that you want for this device."
CLST_PAGE_MAIN_MENU_ITEM1="Master"
CLST_PAGE_MAIN_MENU_ITEM2="Slave"
CLST_PAGE_MAIN_MENU_LABEL_OK="Next"
CLST_PAGE_MAIN_MENU_ERROR_UNKNOWN="Unknown error"


########################################
# Cluster mode -> VERIFY_SWITCH_TO_MST
########################################
CLST_PAGE_VERIFY_SWITCH_TO_MST_TITLE="Device Role Modification Confirmation"
CLST_PAGE_VERIFY_SWITCH_TO_MST_TEXT="Do you want to change the role of this device to master?"
CLST_PAGE_VERIFY_SWITCH_TO_MST_LABEL_OK="Yes"
CLST_PAGE_VERIFY_SWITCH_TO_MST_LABEL_CANCEL="No"
CLST_PAGE_VERIFY_SWITCH_TO_MST_IS_NOT_SWITCHABLE="This device cannot change its role to master. This cluster already has a master device. Detach this device from the cluster and try again."
CLST_PAGE_VERIFY_SWITCH_TO_MST_ERROR_SWITCH="Cannot change role to master."
CLST_PAGE_VERIFY_SWITCH_TO_MST_ERROR_UNKNOWN="Unknown error"


########################################
# Cluster mode -> VERIFY_SHUTDOWN
########################################
CLST_PAGE_VERIFY_SHUTDOWN_TITLE="Device Role Modification Confirmation"
CLST_PAGE_VERIFY_SHUTDOWN_TEXT="Do you want to change the role of this device to slave?"
CLST_PAGE_VERIFY_SHUTDOWN_LABEL_OK="Yes"
CLST_PAGE_VERIFY_SHUTDOWN_LABEL_CANCEL="No"
CLST_PAGE_VERIFY_SHUTDOWN_ERROR_SHUTDOWN="Cannot change role to slave."
CLST_PAGE_VERIFY_SHUTDOWN_ERROR_UNKNOWN="Unknown error"
